#!/bin/bash

ARCH=`uname -m`
BASH=`command -v bash`
ROOT=`dirname $0`
START_PATH=$ROOT/64-bit

LIBS=(libpthread.so.0 libpangoft2-1.0.so.0 libpangocairo-1.0.so.0 libpango-1.0.so.0 libgobject-2.0.so.0 libglib-2.0.so.0 libcairo.so.2 libfontconfig.so.1 libdl.so.2 libX11.so.6 libusb-1.0.so.0 libSM.so.6 libXxf86vm.so.1 libgtk-3.so.0 libgdk-3.so.0 libgdk_pixbuf-2.0.so.0 libgio-2.0.so.0 libm.so.6 libgcc_s.so.1 libc.so.6)
if [ ${ARCH} != 'x86_64' ]; then
   echo "ERROR: wrong architecture. f4 is only available for x86_64!"
   exit 1
fi
START_BIN=$START_PATH/f4

PATH=/sbin/:$PATH

ldconfig -p > /dev/null
if [[ $? -eq 127 ]]
then
   echo "ERROR: /sbin/ldconfig not found. ldconfig is necessary to check the dependencies for f4"
   exit 1
fi

for LIB in ${LIBS[*]}
do
	ldconfig -p | grep $LIB > /dev/null
	if [[ $? -ne 0 ]]
	then
		echo -e "\e[1;31mERROR: \e[0m"$LIB" is missing on your system - try to install it with your Package-Manager.";
		read -n1 -rsp $'Press any key to close...\n';
		exit 1;
	fi
done

$START_BIN 2>&1 > /dev/null;